#version 430

in vec3 Normal;
in vec3 Position;

uniform vec3 cameraPos;
uniform samplerCube cube_texture;

const vec3 ambient = vec3(0.2f, 0.2f, 0.2f);

out vec4 Color;

void main() {
	float ratio = 1.0/ 1.3;
	vec3 modelColor = vec3(0.5f, 0.5f, 0.5f);
	vec4 ReflectColor = vec4(modelColor * ambient, 1.0);

	vec3 I = normalize(Position - cameraPos);
	vec3 R = refract(I, normalize(Normal), ratio);

	Color = texture(cube_texture, R);
	Color = mix(Color, ReflectColor, 0.3);
}